/*

このクラスは必ずサーバー側で動作する特別なクラス

参考：
https://developer.4d.com/docs/ja/API/DataStoreClass

*/

Class extends DataStoreImplementation


//mark: -
Function getSharedSettings()->$return : Object
	
	//mark: 環境設定情報を取得
	
	$return:={}
	
	//利用するフォルダーパスをファイルから読み込んで利用する
	$text:=File:C1566("/RESOURCES/path.txt").getText()
	Case of 
		: ($text="@\r@")
			$return.path:="エラー：設定が１行ではない（CRで改行されている）"
		: ($text="@\n@")
			$return.path:="エラー：設定が１行ではない（LFで改行されている）"
		Else 
			$return.path:=$text
	End case 
	
	$return.OK:=Folder:C1567($return.path).exists
	
	
	
	
	//mark: -
Function __getSharedFolder()->$return : Object
	
	//mark: サーバー側の特定のフォルダオブジェクトを取得してオブジェクトとして返す
	
	$object:=Folder:C1567(ds:C1482.getSharedSettings().path)
	
	$return:={}
	For each ($name; $object)
		$return[$name]:=$object[$name]
	End for each 
	
	
	
	//mark: -
Function __getSharedFolderFiles($path : Text; $option : Integer)->$return : Collection
	
	//mark: サーバー側の特定のフォルダ内にあるファイルオブジェクトを取得してオブジェクトとして返す
	
	//ファイルオブジェクトを取得
	$files:=Folder:C1567($path).files($option)
	
	//ファイルオブジェクトをオブジェクト化する
	$return:=[]
	For each ($file; $files)
		$item:={}
		For each ($name; $file)
			$item[$name]:=$file[$name]
		End for each 
		$return.push($item)
	End for each 
	
	
	
	//mark: -
Function __getSharedFile($path : Text)->$return : Object
	
	//mark: サーバー側の指定されたファイルパスにあるファイルオブジェクトを取得してオブジェクトとして返す
	
	$file:=File:C1566($path)
	
	$return:={}
	For each ($name; $file)
		$return[$name]:=$file[$name]
	End for each 
	
	
	//mark: -
Function __getSharedObjectProperties($object : Variant)->$properties : Object
	
	//mark: サーバー側にあるファイル・フォルダーオブジェクトのプロパティをコピー
	
	$properties:={}
	For each ($name; $object)
		$properties[$name]:=$object[$name]
	End for each 
	
	
	//mark: -
Function __executeSharedObjectFunction($object : Object; $function : Text)->$result : Variant
	
	//mark: サーバー側でオブジェクトのファンクションを実行
	
	//オブジェクトからフォルダーオブジェクト／ファイルオブジェクトに変換
	var __OBJECT__ : Variant  //フォーミュラ実行のために宣言する"唯一"の"プロセス変数"
	If ($object.isFolder)
		__OBJECT__:=Folder:C1567($object.path)
	Else 
		__OBJECT__:=File:C1566($object.path)
	End if 
	
	//渡されたファンクションをオブジェクトのクラス関数として実行
	$f:=Formula from string:C1601("__OBJECT__."+$function)
	$result:=$f.call()
	
	//不要になったプロセス変数はクリアしておく
	CLEAR VARIABLE:C89(__OBJECT__)
	