## Description

サーバー側のフォルダーを使いやすくするためのクラス

## Example

```4d
Form.LISTBOX:=cs.ServerFolder.new().files()
```

## Function


### .new()

.new()関数は、サーバー側で指定されているフォルダーのインスタンス化をします。


インスタンス化されたフォルダーは、マシン環境に左右されないようにフォルダーオブジェクトではありません。
フォルダーオブジェクトに準じた純粋なオブジェクトとして生成されます。


| 引数 | 型 | in/out | 概要 |
| --- | --- | --- | --- |
| 戻り値 | Object | <- out | サーバー側のフォルダーを示すServerFolderインスタンス |

### .files()

.files()関数は、サーバー側のフォルダー内にあるファイルをリストとしてコレクションに入れて返します。

コレクションとして返されるファイルは、ファイルオブジェクトではありません。
マシン環境に左右されないように、フォルダーオブジェクトに準じた純粋なオブジェクトとして生成された`cs.ServerFile`オブジェクトが収められます。


| 引数 | 型 | in/out | 概要 |
| --- | --- | --- | --- |
| option | Integer | in -> | リスト生成時のオプション（詳細は4D.Folderを参照） |
| list | Collection | <- out | フォルダーに収められたファイルのリスト |
