## Description

クライント側でサーバー側にあるファイルを扱うためのクラス。

`4D.File`クラスのように利用できますが、ファイルオブジェクトとは異なり、単なるオブジェクトで表現されています。
プロパティは、`4D.File`に準じて参照可能です。

クラス関数は、この例題では後述の２つだけ（`.new()`を除く）が用意されています。
他のクラス関数に対応するために拡張する場合は、後述のクラス関数の実装を参考にしてください。

## Example

```4d
$filePath:="/Volumes/Support/▲テクサポ/__共有フォルダー__/test.txt" //注意:サーバー側のファイルパス
$file:=cs.ServerFile.new($filePath)
```

## Function

### .new()

渡されたパスでServerFileオブジェクトのインスタンスを生成。

| 引数 | 型 | in/out | 概要 |
| --- | --- | --- | --- |
| path | Text | in -> | サーバー側のファイルパス |
| file | ServerFileオブジェクト | <- out | ServerFileオブジェクト |

> [!IMPORTANT]
> 
> 渡すパスは、サーバー側のファイルパスである点に注意


### .getContent()

.getContent()関数は、ファイルの全コンテンツを格納した`4D.Blob`オブジェクトを返します。

| 引数 | 型 | in/out | 概要 |
| --- | --- | --- | --- |
| content | Blob | <- out | 取り出したファイルの内容 |


### .getIcon()

.getIcon() 関数は、ファイルのアイコンを返します。

任意の size 引数を渡すと、返されるアイコンのサイズをピクセル単位で指定することができます。 この値は、実際にはアイコンを格納している正方形の一辺の長さを表しています。 アイコンは通常、32x32ピクセル ("大きいアイコン") または 16x16ピクセル ("小さいアイコン") で定義されています。 この引数に 0 を渡すか省略した場合、"大きいアイコン" が返されます。

ファイルがディスク上に存在しない場合、デフォルトの空のアイコンが返されます。


| 引数 | 型 | in/out | 概要 |
| --- | --- | --- | --- |
| icon | Picture | <- out | 取り出したファイルの内容 |
